var __extends = this.__extends || function (d, b) {
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MemoryAnalyzer;
(function (MemoryAnalyzer) {
    var SnapshotTileViewModel = (function () {
        function SnapshotTileViewModel(summary, snapshotSummaryCollection) {
            this._summary = summary;
            this._snapshotSummaryCollection = snapshotSummaryCollection;
        }
        Object.defineProperty(SnapshotTileViewModel.prototype, "summaryData", {
            get: function () {
                return this._summary;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "timeTaken", {
            get: function () {
                var date = new Date(this._summary.taken);
                return "(" + date.toLocaleTimeString() + ")";
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "processPrivateBytes", {
            get: function () {
                return MemoryAnalyzer.FormattingHelpers.getPrettyPrintSize(parseInt(this.summaryData.processPrivateBytes));
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "heapSize", {
            get: function () {
                return MemoryAnalyzer.FormattingHelpers.getPrettyPrintSize(this.summaryData.heapSize);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "totalObjectSize", {
            get: function () {
                return MemoryAnalyzer.FormattingHelpers.getPrettyPrintSize(this.summaryData.totalObjectSize);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "objectsCount", {
            get: function () {
                return this.summaryData.objectsCount;
            },
            enumerable: true,
            configurable: true
        });
        SnapshotTileViewModel.prototype.getComparableSnapshots = function () {
            var result = [];
            var currentSnapshotDate = this._summary.taken;
            for(var i = 0; i < this._snapshotSummaryCollection.length; i++) {
                var snapshot = this._snapshotSummaryCollection.getItem(i);
                if(snapshot.id !== this._summary.id) {
                    result.push(snapshot);
                }
            }
            result = result.sort(function (a, b) {
                return a.id - b.id;
            });
            return result;
        };
        return SnapshotTileViewModel;
    })();
    MemoryAnalyzer.SnapshotTileViewModel = SnapshotTileViewModel;    
    var SnapshotTileView = (function (_super) {
        __extends(SnapshotTileView, _super);
        function SnapshotTileView(controller, model) {
                _super.call(this, "SnapshotTileTemplate");
            this._controller = controller;
            this._model = model;
            this._menuControl = new MemoryAnalyzer.Controls.MenuControl(this.findElement("compareButton"));
            this.findElement("compareButton").setAttribute("data-plugin-vs-tooltip", Plugin.Resources.getString("CompareButtonTooltipText"));
            this.findElement("compareButton").setAttribute("aria-label", Plugin.Resources.getString("CompareButtonTooltipText"));
            this._comparableSnapshots = this._model.getComparableSnapshots();
            this._tileHeader = this.findElement("snapshotTileHeader");
            this.findElement("snapshotTileTitle").innerText = Plugin.Resources.getString("SnapshotNumber", this._model.summaryData.id);
            if(this._model.summaryData.screenshotData) {
                var imgHolder = this.findElement("snapshotTileImage");
                imgHolder.src = "data:image/jpeg;base64," + this._model.summaryData.screenshotData.replace(/\r\n/g, "");
                imgHolder.alt = Plugin.Resources.getString("Screenshot");
            }
            var objectsCountText = MemoryAnalyzer.FormattingHelpers.getDecimalLocaleString(this._model.objectsCount, true);
            this.findElement("snapshotTakenDate").innerText = this._model.timeTaken;
            this.findElement("heapSizeLink").innerText = Plugin.Resources.getString("HeapSize", this._model.totalObjectSize);
            this.findElement("objectsCountLink").innerText = Plugin.Resources.getString("ObjectsCount", objectsCountText);
            this.findElement("heapSizeLink").setAttribute("data-plugin-vs-tooltip", Plugin.Resources.getString("HeapSizeLinkTooltip"));
            this.findElement("objectsCountLink").setAttribute("data-plugin-vs-tooltip", Plugin.Resources.getString("ObjectsCountLinkTooltip"));
            this.setupSizeDiff(this.findElement("heapDiffLink"));
            this.setupCountDiff(this.findElement("objectsDiffLink"));
            this.findElement("heapSizeLink").onclick = this.onSizeClick.bind(this);
            this.findElement("objectsCountLink").onclick = this.onObjectCountClick.bind(this);
            this.findElement("heapDiffLink").onclick = this.onDiffClick.bind(this);
            this.findElement("objectsDiffLink").onclick = this.onObjectDiffClick.bind(this);
            this.populateCompareMenus();
        }
        SnapshotTileView.prototype.onCollectionChanged = function (eventArgs) {
            if(eventArgs.action === MemoryAnalyzer.Controls.NotifyCollectionChangedAction.Add) {
                var newSummary = eventArgs.newItems[0];
                if(this._model.summaryData.id !== newSummary.id) {
                    this._menuControl.addItem(Plugin.Resources.getString("SnapshotNumber", newSummary.id), this.diffTo.bind(this, newSummary.id));
                }
            }
        };
        SnapshotTileView.prototype.populateCompareMenus = function () {
            this._comparableSnapshots = this._model.getComparableSnapshots();
            for(var i = 0; i < this._comparableSnapshots.length; i++) {
                var comparable = this._comparableSnapshots[i];
                this._menuControl.addItem(Plugin.Resources.getString("SnapshotNumber", comparable.id), this.diffTo.bind(this, comparable.id));
            }
        };
        SnapshotTileView.prototype.setFocus = function () {
            this._tileHeader.focus();
        };
        SnapshotTileView.prototype.setupSizeDiff = function (element) {
            var toSnapshot = this._comparableSnapshots[this._model.summaryData.id - 2];
            if(toSnapshot) {
                var size = (this._model.summaryData.totalObjectSize - toSnapshot.totalObjectSize);
                if(size > 0) {
                    element.classList.add("growthLink");
                } else {
                    element.classList.add("shrinkLink");
                }
                if(size === 0) {
                    element.innerText = Plugin.Resources.getString("NoDiff");
                } else {
                    element.innerText = "(" + (size > 0 ? "+" : "-") + MemoryAnalyzer.FormattingHelpers.getPrettyPrintSize(size) + ")";
                    element.setAttribute("data-plugin-vs-tooltip", Plugin.Resources.getString("HeapSizeDiffLinkTooltip"));
                }
                element.href = "#";
            } else {
                element.classList.add("baselineText");
                element.innerText = Plugin.Resources.getString("Baseline");
            }
        };
        SnapshotTileView.prototype.setupCountDiff = function (element) {
            var toSnapshot = this._comparableSnapshots[this._model.summaryData.id - 2];
            if(toSnapshot) {
                var count = this._model.objectsCount - toSnapshot.objectsCount;
                if(count > 0) {
                    element.classList.add("growthLink");
                } else {
                    element.classList.add("shrinkLink");
                }
                if(count === 0) {
                    element.innerText = Plugin.Resources.getString("NoDiff");
                } else {
                    element.innerText = "(" + (count > 0 ? "+" : "-") + Plugin.Resources.getString("ObjectsCount", MemoryAnalyzer.FormattingHelpers.getDecimalLocaleString(count, true)) + ")";
                    element.setAttribute("data-plugin-vs-tooltip", Plugin.Resources.getString("ObjectsCountDiffLinkTooltip"));
                }
                element.href = "#";
            } else {
                element.classList.add("baselineText");
                element.innerText = Plugin.Resources.getString("Baseline");
                element.tabIndex = -1;
            }
        };
        SnapshotTileView.prototype.onSizeClick = function (e) {
            this._controller.viewSnapshot(this._model.summaryData.id, "Dominators");
        };
        SnapshotTileView.prototype.onObjectCountClick = function (e) {
            this._controller.viewSnapshot(this._model.summaryData.id, "Types");
        };
        SnapshotTileView.prototype.diffTo = function (id) {
            this._controller.compareSnapshots(this._model.summaryData.id, id, "Dominators");
        };
        SnapshotTileView.prototype.onDiffClick = function (e) {
            var toSnapshot = this._comparableSnapshots[this._model.summaryData.id - 2];
            if(toSnapshot) {
                this._controller.compareSnapshots(this._model.summaryData.id, toSnapshot.id, "Dominators");
            }
        };
        SnapshotTileView.prototype.onObjectDiffClick = function (e, target) {
            var toSnapshot = this._comparableSnapshots[this._model.summaryData.id - 2];
            if(toSnapshot) {
                this._controller.compareSnapshots(this._model.summaryData.id, toSnapshot.id, "Types");
            }
        };
        return SnapshotTileView;
    })(Common.Controls.TemplateControl);
    MemoryAnalyzer.SnapshotTileView = SnapshotTileView;    
})(MemoryAnalyzer || (MemoryAnalyzer = {}));
//@ sourceMappingURL=snapshotTileView.js.map

// SIG // Begin signature block
// SIG // MIIanQYJKoZIhvcNAQcCoIIajjCCGooCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFFJtAiPRtZxq
// SIG // 4qPOQ7XP9ke3IA+coIIVeTCCBLowggOioAMCAQICCmEC
// SIG // kkoAAAAAACAwDQYJKoZIhvcNAQEFBQAwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBMB4XDTEyMDEwOTIyMjU1OVoXDTEz
// SIG // MDQwOTIyMjU1OVowgbMxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // RFNFIEVTTjpCOEVDLTMwQTQtNzE0NDElMCMGA1UEAxMc
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM1jw/ei
// SIG // tUfZ+TmUU6xrj6Z5OCH00W49FTgWwXMsmY/74Dxb4aJM
// SIG // i7Kri7TySse5k1DRJvWHU7B6dfNHDxcrZyxk62DnSozg
// SIG // i17EVmk3OioEXRcByL+pt9PJq6ORqIHjPy232OTEeAB5
// SIG // Oc/9x2TiIxJ4ngx2J0mPmqwOdOMGVVVJyO2hfHBFYX6y
// SIG // cRYe4cFBudLSMulSJPM2UATX3W88SdUL1HZA/GVlE36V
// SIG // UTrV/7iap1drSxXlN1gf3AANxa7q34FH+fBSrubPWqzg
// SIG // FEqmcZSA+v2wIzBg6YNgrA4kHv8R8uelVWKV7p9/ninW
// SIG // zUsKdoPwQwTfBkkg8lNaRLBRejkCAwEAAaOCAQkwggEF
// SIG // MB0GA1UdDgQWBBTNGaxhTZRnK/avlHVZ2/BYAIOhOjAf
// SIG // BgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7syuwwzWzDzBU
// SIG // BgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsGAQUFBwEBBEww
// SIG // SjBIBggrBgEFBQcwAoY8aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRUaW1lU3Rh
// SIG // bXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQBRHNbfNh3cgLwCp8aZ3xbI
// SIG // kAZpFZoyufNkENKK82IpG3mPymCps13E5BYtNYxEm/H0
// SIG // XGGkQa6ai7pQ0Wp5arNijJ1NUVALqY7Uv6IQwEfVTnVS
// SIG // iR4/lmqPLkAUBnLuP3BZkl2F7YOZ+oKEnuQDASETqyfW
// SIG // zHFJ5dod/288CU7VjWboDMl/7jEUAjdfe2nsiT5FfyVE
// SIG // 5x8a1sUaw0rk4fGEmOdP+amYpxhG7IRs7KkDCv18elId
// SIG // nGukqA+YkqSSeFwreON9ssfZtnB931tzU7+q1GZQS/DJ
// SIG // O5WF5cFKZZ0lWFC7IFSReTobB1xqVyivMcef58Md7kf9
// SIG // J9d/z3TcZcU/MIIE7DCCA9SgAwIBAgITMwAAALARrwqL
// SIG // 0Duf3QABAAAAsDANBgkqhkiG9w0BAQUFADB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQTAeFw0xMzAxMjQyMjMzMzla
// SIG // Fw0xNDA0MjQyMjMzMzlaMIGDMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYDVQQDExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQDor1yiIA34KHy8BXt/re7r
// SIG // dqwoUz8620B9s44z5lc/pVEVNFSlz7SLqT+oN+EtUO01
// SIG // Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Unm/P4LZ5BNisL
// SIG // QPu+O7q5XHWTFlJLyjPFN7Dz636o9UEVXAhlHSE38Cy6
// SIG // IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpOoPXJCiHiquMB
// SIG // Nkf9L4JqgQP1qTXclFed+0vUDoLbOI8S/uPWenSIZOFi
// SIG // xCUuKq6dGB8OHrbCryS0DlC83hyTXEmmebW22875cHso
// SIG // AYS4KinPv6kFBeHgD3FN/a1cI4Mp68fFSsjoJ4TTfsZD
// SIG // C5UABbFPZXHFAgMBAAGjggFgMIIBXDATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGmWjNN2pgHgP+E
// SIG // Hr6H+XIyQfIwUQYDVR0RBEowSKRGMEQxDTALBgNVBAsT
// SIG // BE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRmYWYwYjcxLWFk
// SIG // MzctNGFhMy1hNjcxLTc2YmMwNTIzNDRhZDAfBgNVHSME
// SIG // GDAWgBTLEejK0rQWWAHJNy4zFha5TJoKHzBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0Ff
// SIG // MDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8wOC0zMS0y
// SIG // MDEwLmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMdduKhJX
// SIG // M4HVncbr+TrURE0Inu5e32pbt3nPApy8dmiekKGcC8N/
// SIG // oozxTbqVOfsN4OGb9F0kDxuNiBU6fNutzrPJbLo5LEV9
// SIG // JBFUJjANDf9H6gMH5eRmXSx7nR2pEPocsHTyT2lrnqkk
// SIG // hNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2yRPnwPJNtQtjo
// SIG // fOYXoJtoaAko+QKX7xEDumdSrcHps3Om0mPNSuI+5PNO
// SIG // /f+h4LsCEztdIN5VP6OukEAxOHUoXgSpRm3m9Xp5QL0f
// SIG // zehF1a7iXT71dcfmZmNgzNWahIeNJDD37zTQYx2xQmdK
// SIG // Dku/Og7vtpU6pzjkJZIIpohmgjCCBbwwggOkoAMCAQIC
// SIG // CmEzJhoAAAAAADEwDQYJKoZIhvcNAQEFBQAwXzETMBEG
// SIG // CgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixkARkW
// SIG // CW1pY3Jvc29mdDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJv
// SIG // b3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MB4XDTEwMDgz
// SIG // MTIyMTkzMloXDTIwMDgzMTIyMjkzMloweTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENv
// SIG // ZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCycllcGTBkvx2aYCAgQpl2U2w+
// SIG // G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/3sJCTiPVcgDb
// SIG // NVcKicquIEn08GisTUuNpb15S3GbRwfa/SXfnXWIz6pz
// SIG // RH/XgdvzvfI2pMlcRdyvrT3gKGiXGqelcnNW8ReU5P01
// SIG // lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJpL9oZC/6SdCni
// SIG // di9U3RQwWfjSjWL9y8lfRjFQuScT5EAwz3IpECgixzdO
// SIG // PaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn0i1i8UU956wI
// SIG // APZGoZ7RW4wmU+h6qkryRs83PDietHdcpReejcsRj1Y8
// SIG // wawJXwPTAgMBAAGjggFeMIIBWjAPBgNVHRMBAf8EBTAD
// SIG // AQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGCNxUBBAUCAwEA
// SIG // ATAjBgkrBgEEAYI3FQIEFgQU/dExTtMmipXhmGA7qDFv
// SIG // pjy82C0wGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // HwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8KuEKU5VZ5KQw
// SIG // UAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvbWljcm9z
// SIG // b2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUFBwEBBEgwRjBE
// SIG // BggrBgEFBQcwAoY4aHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNyb3NvZnRSb290Q2VydC5j
// SIG // cnQwDQYJKoZIhvcNAQEFBQADggIBAFk5Pn8mRq/rb0Cx
// SIG // MrVq6w4vbqhJ9+tfde1MOy3XQ60L/svpLTGjI8x8UJiA
// SIG // IV2sPS9MuqKoVpzjcLu4tPh5tUly9z7qQX/K4QwXacul
// SIG // nCAt+gtQxFbNLeNK0rxw56gNogOlVuC4iktX8pVCnPHz
// SIG // 7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y4k74jKHK6BOl
// SIG // kU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wdzaKMvSeyeWNW
// SIG // RKJRzfnpo1hW3ZsCRUQvX/TartSCMm78pJUT5Otp56mi
// SIG // LL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q70eFW6NB4lhhc
// SIG // yTUWX92THUmOLb6tNEQc7hAVGgBd3TVbIc6YxwnuhQ6M
// SIG // T20OE049fClInHLR82zKwexwo1eSV32UjaAbSANa98+j
// SIG // Zwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKNMxZlHg6K3RDe
// SIG // ZPRvzkbU0xfpecQEtNP7LN8fip6sCvsTJ0Ct5PnhqX9G
// SIG // uwdgR2VgQE6wQuxO7bN2edgKNAltHIAxH+IOVN3lofvl
// SIG // RxCtZJj/UBYufL8FIXrilUEnacOTj5XJjdibIa4NXJzw
// SIG // oq6GaIMMai27dmsAHZat8hZ79haDJLmIz2qoRzEvmtzj
// SIG // cT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq/2mbluIQqBC0
// SIG // N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZoNAAAAAAAHDAN
// SIG // BgkqhkiG9w0BAQUFADBfMRMwEQYKCZImiZPyLGQBGRYD
// SIG // Y29tMRkwFwYKCZImiZPyLGQBGRYJbWljcm9zb2Z0MS0w
// SIG // KwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0
// SIG // ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1MzA5WhcNMjEw
// SIG // NDAzMTMwMzA5WjB3MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEw
// SIG // HwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Ew
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCf
// SIG // oWyx39tIkip8ay4Z4b3i48WZUSNQrc7dGE4kD+7Rp9FM
// SIG // rXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr6Hu97IkHD/cO
// SIG // BJjwicwfyzMkh53y9GccLPx754gd6udOo6HBI1PKjfpF
// SIG // zwnQXq/QsEIEovmmbJNn1yjcRlOwhtDlKEYuJ6yGT1VS
// SIG // DOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd++NIT8wi3U21S
// SIG // tEWQn0gASkdmEScpZqiX5NMGgUqi+YSnEUcUCYKfhO1V
// SIG // eP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68eeEExd8yb3zuD
// SIG // k6FhArUdDbH895uyAc4iS1T/+QXDwiALAgMBAAGjggGr
// SIG // MIIBpzAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQj
// SIG // NPjZUkZwCu1A+3b7syuwwzWzDzALBgNVHQ8EBAMCAYYw
// SIG // EAYJKwYBBAGCNxUBBAMCAQAwgZgGA1UdIwSBkDCBjYAU
// SIG // DqyCYEBWJ5flJRP8KuEKU5VZ5KShY6RhMF8xEzARBgoJ
// SIG // kiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZFglt
// SIG // aWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290
// SIG // IENlcnRpZmljYXRlIEF1dGhvcml0eYIQea0WoUqgpa1M
// SIG // c1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9taWNyb3NvZnRyb290Y2VydC5jcmwwVAYIKwYBBQUH
// SIG // AQEESDBGMEQGCCsGAQUFBzAChjhodHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFJv
// SIG // b3RDZXJ0LmNydDATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wDRDbd6bStd9vO
// SIG // eVFNAbEudHFbbQwTq86+e4+4LtQSooxtYrhXAstOIBNQ
// SIG // md16QOJXu69YmhzhHQGGrLt48ovQ7DsB7uK+jwoFyI1I
// SIG // 4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mRKiQicPv2/OR4
// SIG // mS4N9wficLwYTp2OawpylbihOZxnLcVRDupiXD8WmIsg
// SIG // P+IHGjL5zDFKdjE9K3ILyOpwPf+FChPfwgphjvDXuBfr
// SIG // Tot/xTUrXqO/67x9C0J71FNyIe4wyrt4ZVxbARcKFA7S
// SIG // 2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGysOUzU9nm/qhh6
// SIG // YinvopspNAZ3GmLJPR5tH4LwC8csu89Ds+X57H2146So
// SIG // dDW4TsVxIxImdgs8UoxxWkZDFLyzs7BNZ8ifQv+AeSGA
// SIG // nhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU2DKATCYqSCRf
// SIG // WupW76bemZ3KOm+9gSd0BhHudiG/m4LBJ1S2sWo9iaF2
// SIG // YbRuoROmv6pH8BJv/YoybLL+31HIjCPJZr2dHYcSZAI9
// SIG // La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCleKuzoJZ1GtmS
// SIG // hxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/Jmu5J4PcBZW+J
// SIG // C33Iacjmbuqnl84xKf8OxVtc2E0bodj6L54/LlUWa8kT
// SIG // o/0xggSQMIIEjAIBATCBkDB5MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWdu
// SIG // aW5nIFBDQQITMwAAALARrwqL0Duf3QABAAAAsDAJBgUr
// SIG // DgMCGgUAoIGyMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3
// SIG // AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEV
// SIG // MCMGCSqGSIb3DQEJBDEWBBRjY0LVqdgFQ2FRpVXLt4Hk
// SIG // KDk1fTBSBgorBgEEAYI3AgEMMUQwQqAogCYAcwBuAGEA
// SIG // cABzAGgAbwB0AFQAaQBsAGUAVgBpAGUAdwAuAGoAc6EW
// SIG // gBRodHRwOi8vbWljcm9zb2Z0LmNvbTANBgkqhkiG9w0B
// SIG // AQEFAASCAQCGIuuc2M8/n33AoGNOG+Oq8F9YiLl5RLXF
// SIG // ZiKFTz1V0J1Z/Gr/ru/Awr7Bm1M2EqfqpLXsBlbAGKSo
// SIG // TyIzJ19jjBnIhCK+gxkX5LU3VHtYGoEBBOmJvzVzQCsR
// SIG // fJRx01/jrq2FlQfhSXIwnJ+pysIDvnyMKeoovapukvU/
// SIG // FGmJ4eh7DMR9YlFg2pca017EalG55QBoopv3swQAibyO
// SIG // 7zlpzQVq3bSSZiV3FKwzXIRuAAwqWTEN4530Bb6mhhwB
// SIG // XOygp2nhE2REI+dNamF0fwB6mTGzr7tarnywGmtdpofa
// SIG // /X84VMuynbs9lkYK6plKpUFWrXZN0fyG+6BKurzz6rb2
// SIG // oYICHzCCAhsGCSqGSIb3DQEJBjGCAgwwggIIAgEBMIGF
// SIG // MHcxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
// SIG // dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVN
// SIG // aWNyb3NvZnQgQ29ycG9yYXRpb24xITAfBgNVBAMTGE1p
// SIG // Y3Jvc29mdCBUaW1lLVN0YW1wIFBDQQIKYQKSSgAAAAAA
// SIG // IDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqG
// SIG // SIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMTMwMzE1MDYz
// SIG // MzU4WjAjBgkqhkiG9w0BCQQxFgQU3qrbDwbS3u2cjsGh
// SIG // 2rEhi4x3iEIwDQYJKoZIhvcNAQEFBQAEggEAoHfSns6O
// SIG // 9geqv4KT1tufknNWZi05R2Q8wn2tRPpqEhPjXOS+kWxR
// SIG // ZDA4hXOlI3ALHiG1D1VuoR30VZ1luxq3F3i0UJ2s3jgl
// SIG // +dWW5lSjS+qfPLcerdmK0qAE6luDyRqSM5pPCuhfGmDe
// SIG // AIs0BQmJ2ALQrQ2cUCHBjx7U+mYwVijcSJp3CP39gPbg
// SIG // MhtTxDOqB27Hf2xU6+g2fnSpBSJSQJtdot3UKUrtACp4
// SIG // LrOZn/BAmhTCyWURsw0QLN6ol3HCC9cW3hAf88I4sQkI
// SIG // ym+GKyr+Yg5aUhERpVDvTLYZUFUgwSy5dPIJzxrb/nnN
// SIG // /c/AhGrMMTKaEYN3gNFZjAXUOg==
// SIG // End signature block
